"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
0 && (module.exports = {
    deleteAppClientCache: null,
    deleteCache: null,
    NextJsRequireCacheHotReloader: null
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    deleteAppClientCache: function() {
        return deleteAppClientCache;
    },
    deleteCache: function() {
        return deleteCache;
    },
    NextJsRequireCacheHotReloader: function() {
        return NextJsRequireCacheHotReloader;
    }
});
const _sandbox = require("../../../server/web/sandbox");
const _realpath = require("../../../lib/realpath");
const _path = /*#__PURE__*/ _interop_require_default(require("path"));
const _iserror = /*#__PURE__*/ _interop_require_default(require("../../../lib/is-error"));
const _loadmanifest = require("../../../server/load-manifest");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const originModules = [
    require.resolve("../../../server/require"),
    require.resolve("../../../server/load-components"),
    require.resolve("../../../server/next-server"),
    require.resolve("../../../compiled/react-server-dom-webpack/client.edge"),
    require.resolve("../../../compiled/react-server-dom-webpack-experimental/client.edge")
];
const RUNTIME_NAMES = [
    "webpack-runtime",
    "webpack-api-runtime"
];
function deleteAppClientCache() {
    if (global._nextDeleteAppClientCache) {
        global._nextDeleteAppClientCache();
    }
    // ensure we reset the cache for sc_server components
    // loaded via react-server-dom-webpack
    const reactServerDomModId = require.resolve("react-server-dom-webpack/client.edge");
    const reactServerDomMod = require.cache[reactServerDomModId];
    if (reactServerDomMod) {
        for (const child of reactServerDomMod.children){
            child.parent = null;
            delete require.cache[child.id];
        }
    }
    delete require.cache[reactServerDomModId];
}
function deleteCache(filePath) {
    if (global._nextDeleteCache) {
        global._nextDeleteCache(filePath);
    }
    // try to clear it from the fs cache
    (0, _loadmanifest.clearManifestCache)(filePath);
    try {
        filePath = (0, _realpath.realpathSync)(filePath);
    } catch (e) {
        if ((0, _iserror.default)(e) && e.code !== "ENOENT") throw e;
    }
    const mod = require.cache[filePath];
    if (mod) {
        // remove the child reference from the originModules
        for (const originModule of originModules){
            const parent = require.cache[originModule];
            if (parent) {
                const idx = parent.children.indexOf(mod);
                if (idx >= 0) parent.children.splice(idx, 1);
            }
        }
        // remove parent references from external modules
        for (const child of mod.children){
            child.parent = null;
        }
        delete require.cache[filePath];
        return true;
    }
    return false;
}
const PLUGIN_NAME = "NextJsRequireCacheHotReloader";
class NextJsRequireCacheHotReloader {
    constructor(opts){
        this.prevAssets = null;
        this.hasServerComponents = opts.hasServerComponents;
    }
    apply(compiler) {
        compiler.hooks.assetEmitted.tap(PLUGIN_NAME, (_file, { targetPath  })=>{
            deleteCache(targetPath);
            // Clear module context in other processes
            if (global._nextClearModuleContext) {
                global._nextClearModuleContext(targetPath);
            }
            // Clear module context in this process
            (0, _sandbox.clearModuleContext)(targetPath);
        });
        compiler.hooks.afterEmit.tap(PLUGIN_NAME, (compilation)=>{
            RUNTIME_NAMES.forEach((name)=>{
                const runtimeChunkPath = _path.default.join(compilation.outputOptions.path, `${name}.js`);
                deleteCache(runtimeChunkPath);
            });
            let hasAppPath = false;
            // we need to make sure to clear all server entries from cache
            // since they can have a stale webpack-runtime cache
            // which needs to always be in-sync
            const entries = [
                ...compilation.entries.keys()
            ].filter((entry)=>{
                const isAppPath = entry.toString().startsWith("app/");
                hasAppPath = hasAppPath || isAppPath;
                return entry.toString().startsWith("pages/") || isAppPath;
            });
            if (hasAppPath) {}
            entries.forEach((page)=>{
                const outputPath = _path.default.join(compilation.outputOptions.path, page + ".js");
                deleteCache(outputPath);
            });
        });
    }
}

//# sourceMappingURL=nextjs-require-cache-hot-reloader.js.map