/// <reference types="node" />
import type { AsyncLocalStorage } from 'async_hooks';
import type { IncrementalCache } from '../../server/lib/incremental-cache';
import type { DynamicServerError } from './hooks-server-context';
export interface StaticGenerationStore {
    readonly isStaticGeneration: boolean;
    readonly pathname: string;
    readonly originalPathname?: string;
    readonly incrementalCache?: IncrementalCache;
    readonly isOnDemandRevalidate?: boolean;
    readonly isPrerendering?: boolean;
    readonly isRevalidate?: boolean;
    forceDynamic?: boolean;
    fetchCache?: 'only-cache' | 'force-cache' | 'default-cache' | 'force-no-store' | 'default-no-store' | 'only-no-store';
    revalidate?: false | number;
    forceStatic?: boolean;
    dynamicShouldError?: boolean;
    pendingRevalidates?: Promise<any>[];
    dynamicUsageDescription?: string;
    dynamicUsageStack?: string;
    dynamicUsageErr?: DynamicServerError;
    nextFetchId?: number;
    pathWasRevalidated?: boolean;
    tags?: string[];
    revalidatedTags?: string[];
    fetchMetrics?: Array<{
        url: string;
        idx: number;
        end: number;
        start: number;
        method: string;
        status: number;
        cacheStatus: 'hit' | 'miss';
    }>;
    isDraftMode?: boolean;
}
export type StaticGenerationAsyncStorage = AsyncLocalStorage<StaticGenerationStore>;
export declare const staticGenerationAsyncStorage: StaticGenerationAsyncStorage;
